<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('cashouts', function (Blueprint $table) {
            $table->id();

            $table->integer('user_id')->unsigned();
            $table->foreign('user_id')->references('id')->on('users');

            $table->foreignId('agent_id')->constrained();
            $table->foreignId('agent_package_id')->constrained();

            $table->integer('currency_id')->unsigned();
            $table->foreign('currency_id')->references('id')->on('currencies');

            $table->integer('payment_method_id')->unsigned();
            $table->foreign('payment_method_id')->references('id')->on('payment_methods');

            $table->string('uuid')->unique();
            $table->string('payment_method_info');
            $table->decimal('agent_percentage', 8, 2);
            $table->decimal('charge_percentage', 8, 2);
            $table->decimal('charge_fixed', 8, 2);
            $table->decimal('subtotal', 10, 2);
            $table->decimal('amount', 10, 2);
            $table->decimal('total', 10, 2);
            $table->string('status');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cashouts');
    }
};
