<?php

namespace Modules\Agent\Http\Controllers\Admin;

use App\Models\Preference;
use App\Http\Helpers\Common;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Session;
use Illuminate\Contracts\Support\Renderable;

class PreferenceController extends Controller
{
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function index()
    {
        $data['menu'] = 'agents';
        $data['sub_menu'] = 'preferences';
        return view('agent::index');
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {
        $data['menu'] = 'agents';
        $data['sub_menu'] = 'preferences';

        $transformedArray = [];

        foreach (Preference::getAll() as $preference) {
            $transformedArray['preference'][$preference->field] = $preference->value;
        }

        $data['prefData'] = $transformedArray;
        
        return view('agent::admin.preferences.create', $data);
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(Request $request)
    {

        $post = $request->all();
        unset($post['_token']);

        $i = 0;
        foreach ($post as $key => $value) {
            $data[$i]['category'] = "preference";
            $data[$i]['field']    = $key;
            $data[$i]['value']    = $value;
            $i++;
        } foreach ($data as $key => $value) {
            $category = $value['category'];
            $field    = $value['field'];
            $val      = $value['value'];
            $res      = Preference::where(['field' => $field])->first();

            if (empty($res)) {
                DB::insert(DB::raw("INSERT INTO preferences(category,field,value) VALUES ('$category','$field','$val')"));
            } else {
                Preference::where(['category' => 'preference', 'field' => $field])->update(array('field' => $field, 'value' => $val));
            }
        }

        Cache::forget(config('cache.prefix') . '-preferences');

        $pref = Preference::where('category', 'preference')->get();
        if (!empty($pref)) {
            foreach ($pref as $value) {
                $prefer[$value->field] = $value->value;
            }
            Session::put($prefer);
        }

        Common::one_time_message('success', __('The :x has been successfully saved.', ['x' => __('preference')]));
        return redirect()->route('admin.agents.preferences.create');
    }
}
