<?php

namespace Modules\Agent\Http\Middleware;

use App\Http\Helpers\Common;
use App\Traits\ApiResponse;
use Closure;


class CheckAgentInactive
{
    use ApiResponse;
   
    public function handle($request, Closure $next)
    {
        // if user inactive wouldn't be able to login
        $agent = auth('agent-v2')->user() ?? auth('agent')->user();
        $user = Common::getUserStatus($agent->status);

        if ($user == 'Inactive') {
            $prefix = str_replace('/', '', request()->route()->getPrefix());
            if (str_contains($prefix, 'apiv2')) {
                return $this->unauthorizedResponse([], __("Inactive"));
            }
            auth()->logout();
            Common::one_time_message('danger', __('Your account has been inactivated. Please retry later'));
            return redirect('/agent');
        }
        return $next($request);
    }
}
