"use strict";

$(".select2").select2();

if ($('.content').find('#revenue').length) {

    $(document).ready(function () {
        let $daterangeBtn = $('#daterange-btn');
        let $startFrom = $('#startfrom');
        let $endTo = $('#endto');
    
        $daterangeBtn.daterangepicker({
            ranges: {
                'Today': [moment(), moment()],
                'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                'This Month': [moment().startOf('month'), moment().endOf('month')],
                'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
            },
            startDate: moment().subtract(29, 'days'),
            endDate: moment()
        }, function (start, end) {
            let sessionDateFinal = sessionDate.toUpperCase();
        
            let sDate = moment(start, 'MMMM D, YYYY').format(sessionDateFinal);
            $startFrom.val(sDate);
        
            let eDate = moment(end, 'MMMM D, YYYY').format(sessionDateFinal);
            $endTo.val(eDate);
        
            $daterangeBtn.find('span').html('&nbsp;' + sDate + ' - ' + eDate + '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;');
        });
    
        $daterangeBtn.on({
            mouseover: function () {
                $(this).css({
                    'background-color': 'white',
                    'border-color': 'grey'
                });
            }
        });
    
        if (startDate === '') {
            $daterangeBtn.find('span').html('<i class="fa fa-calendar"></i> &nbsp;&nbsp; Pick a date range &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;');
        } else {
            $daterangeBtn.find('span').html(startDate + ' - ' + endDate + '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;');
        }
    });
}