@extends('admin.layouts.master')

@section('title', __('Agent Cashin'))

@section('head_style')

    <!-- Bootstrap daterangepicker -->
    <link rel="stylesheet" href="{{ asset('public/dist/plugins/daterangepicker-3.1/daterangepicker.min.css')}}">

    <link rel="stylesheet" href="{{ asset('public/dist/plugins/DataTables/DataTables-1.10.18/css/jquery.dataTables.min.css') }}">
    <link rel="stylesheet" href="{{ asset('public/dist/plugins/DataTables/Responsive-2.2.2/css/responsive.bootstrap.min.css') }}">

    <!-- jquery-ui-1.12.1 -->
    <link rel="stylesheet" type="text/css" href="{{ asset('public/dist/libraries/jquery-ui-1.12.1/jquery-ui.min.css')}}">
@endsection

@section('page_content')
    <div class="box" id="cashin">
        <div class="box-body pb-20">
            <form action="{{ route('admin.agents.cashin.index') }}" method="get" class="form-horizontal">
                @csrf
                <input type="hidden" name="from" id="startfrom" value="{{ isset($from) ? $from : '' }}">
                <input type="hidden" name="to" id="endto" value="{{ isset($to) ? $to : '' }}">
                <input type="hidden" name="user_id" id="user_id" value="{{ isset($user) ? $user : '' }}">

                <div class="row">
                    <div class="col-md-12">
                        <div class="d-flex flex-wrap justify-content-between align-items-center">
                            <div class="d-flex flex-wrap">
                                
                                <!-- Date and time range -->
                                <div class="pr-25">
                                    <label class="f-14 fw-bold mb-1" for="daterange-btn">{{ __('Date Range') }}</label><br>
                                    <button type="button" class="btn btn-default f-14" id="daterange-btn">
                                        <span id="drp"><i class="fa fa-calendar"></i></span>
                                        <i class="fa fa-caret-down"></i>
                                    </button>
                                </div>

                                <!-- Currency -->
                                <div class="pr-25">
                                    <label class="f-14 fw-bold mb-1" for="currency">{{ __('Currency') }}</label><br>
                                    <select class="form-control select2" name="currency" id="currency">
                                        <option value="all" {{ ($currency == 'all' ) ? 'selected' : '' }} >{{ __('All') }}</option>
                                        @foreach($transactionCurrencies as $cashin)
                                            <option value="{{ $cashin->currency_id }}" {{ ($cashin->currency_id == $currency) ? 'selected' : '' }}>
                                                {{ $cashin->currency?->code }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>

                                <!-- Status -->
                                <div class="pr-25">
                                    <label class="f-14 fw-bold mb-1" for="status">{{ __('Status') }}</label><br>
                                    <select class="form-control select2" name="status" id="status">
                                        <option value="all" {{ ($status == 'all') ? 'selected' : '' }} >{{ __('All') }}</option>
                                        @foreach($transactionStatus as $cashin)
                                            <option value="{{ $cashin->status }}" {{ ($cashin->status == $status) ? 'selected' : '' }}>
                                                {{ ($cashin->status == 'Blocked') ? 'Cancelled' : $cashin->status }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>

                                <!-- User -->
                                <div class="pr-25">
                                    <label class="f-14 fw-bold mb-1" for="user_input">{{ __('User') }}</label><br>
                                    <div class="input-group">
                                        <input id="user_input" type="text" name="user" placeholder="{{ __('Enter Name') }}" class="form-control f-14" value="{{ !empty($getName) ? getColumnValue($getName) : null }}">
                                    </div>
                                    <span class="f-12"  id="error-user"></span>
                                </div>
                            </div>

                            <div>
                                <div class="input-group mt-3">
                                    <button type="submit" name="btn" class="btn btn-theme f-14" id="btn">{{ __('Filter') }}</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <div class="row">
        <div class="col-md-8">
            <p class="panel-title f-14 fw-bold ml-5 f-14">{{ __('All Cash-In') }}</p>
        </div>
        <div class="col-md-4">
            <div class="btn-group pull-right">
                <a href="javascript:void(0)" class="btn btn-sm btn-default btn-flat f-14" id="csv" target="_blank">{{ __('CSV') }}</a>
                <a href="javascript:void(0)" class="btn btn-sm btn-default btn-flat f-14" id="pdf" target="_blank">{{ __('PDF') }}</a>
            </div>
        </div>
    </div>

    <div class="box mt-20">
        <div class="box-body">
            <div class="row">
                <div class="col-md-12 f-14">
                    <div class="panel panel-info">
                        <div class="panel-body">
                            <div class="table-responsive">
                                {!! $dataTable->table(['class' => 'table table-striped table-hover dt-responsive', 'width' => '100%', 'cellspacing' => '0']) !!}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('extra_body_scripts')

    <!-- Bootstrap daterangepicker -->
    <script src="{{ asset('public/dist/plugins/daterangepicker-3.1/daterangepicker.min.js') }}" type="text/javascript"></script>

    <script type="text/javascript" src="{{ asset('public/dist/plugins/DataTables/DataTables-1.10.18/js/jquery.dataTables.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset('public/dist/plugins/DataTables/Responsive-2.2.2/js/dataTables.responsive.min.js') }}"></script>

    <!-- jquery-ui-1.12.1 -->
    <script src="{{ asset('public/dist/libraries/jquery-ui-1.12.1/jquery-ui.min.js') }}" type="text/javascript"></script>

    {!! $dataTable->scripts() !!}

    <script type="text/javascript">
        var csvExportUrl = "{{ route('admin.agents.cashin.printcsv') }}";
        var pdfPrintUrl = "{{ route('admin.agents.cashin.printpdf') }}";
        var startDate = "{!! $from !!}";
        var endDate = "{!! $to !!}";
        var sessionDate = "{{ session('date_format_type') }}";
        var user_input = $('form').find("input[type='text']").val();
        var userSearchUrl = "{{ route('admin.agents.cashin.search.user') }}";
        var sDate, eDate;
    </script>

    <script src="{{ asset('Modules/Agent/Resources/assets/js/admin/cashin.min.js') }}"></script>
    <script src="{{ asset('Modules/Agent/Resources/assets/js/admin/pdf.min.js') }}"></script>
    <script src="{{ asset('Modules/Agent/Resources/assets/js/admin/csv.min.js') }}"></script>
@endpush
